import { Vector2 } from 'math.gl';
import { lerp } from './math-utils';
import { scaleToZoom, zoomToScale, lngLatToWorld, worldToLngLat } from './web-mercator-utils';
var EPSILON = 0.01;
var VIEWPORT_TRANSITION_PROPS = ['longitude', 'latitude', 'zoom'];
export default function flyToViewport(startProps, endProps, t) {
  var viewport = {};
  var rho = 1.414;
  var startZoom = startProps.zoom;
  var startCenter = [startProps.longitude, startProps.latitude];
  var startScale = zoomToScale(startZoom);
  var endZoom = endProps.zoom;
  var endCenter = [endProps.longitude, endProps.latitude];
  var scale = zoomToScale(endZoom - startZoom);
  var startCenterXY = new Vector2(lngLatToWorld(startCenter, startScale));
  var endCenterXY = new Vector2(lngLatToWorld(endCenter, startScale));
  var uDelta = endCenterXY.subtract(startCenterXY);
  var w0 = Math.max(startProps.width, startProps.height);
  var w1 = w0 / scale;
  var u1 = Math.sqrt(uDelta.x * uDelta.x + uDelta.y * uDelta.y);

  if (Math.abs(u1) < EPSILON) {
    for (var _i = 0; _i < VIEWPORT_TRANSITION_PROPS.length; _i++) {
      var key = VIEWPORT_TRANSITION_PROPS[_i];
      var startValue = startProps[key];
      var endValue = endProps[key];
      viewport[key] = lerp(startValue, endValue, t);
    }

    return viewport;
  }

  var rho2 = rho * rho;
  var b0 = (w1 * w1 - w0 * w0 + rho2 * rho2 * u1 * u1) / (2 * w0 * rho2 * u1);
  var b1 = (w1 * w1 - w0 * w0 - rho2 * rho2 * u1 * u1) / (2 * w1 * rho2 * u1);
  var r0 = Math.log(Math.sqrt(b0 * b0 + 1) - b0);
  var r1 = Math.log(Math.sqrt(b1 * b1 + 1) - b1);
  var S = (r1 - r0) / rho;
  var s = t * S;
  var w = Math.cosh(r0) / Math.cosh(r0 + rho * s);
  var u = w0 * ((Math.cosh(r0) * Math.tanh(r0 + rho * s) - Math.sinh(r0)) / rho2) / u1;
  var scaleIncrement = 1 / w;
  var newZoom = startZoom + scaleToZoom(scaleIncrement);
  var newCenter = worldToLngLat(startCenterXY.add(uDelta.scale(u)).scale(scaleIncrement), zoomToScale(newZoom));
  viewport.longitude = newCenter[0];
  viewport.latitude = newCenter[1];
  viewport.zoom = newZoom;
  return viewport;
}
//# sourceMappingURL=fly-to-viewport.js.map