/*
	MIT License http://www.opensource.org/licenses/mit-license.php
*/

"use strict";

const RuntimeGlobals = require("../RuntimeGlobals");
const RuntimeModule = require("../RuntimeModule");

class PublicPathRuntimeModule extends RuntimeModule {
	constructor() {
		super("publicPath", 5);
	}

	/**
	 * @returns {string} runtime code
	 */
	generate() {
		const { compilation } = this;
		const { publicPath } = compilation.outputOptions;

		return `${RuntimeGlobals.publicPath} = ${JSON.stringify(
			this.compilation.getPath(publicPath || "", {
				hash: this.compilation.hash || "XXXX"
			})
		)};`;
	}
}

module.exports = PublicPathRuntimeModule;
