# external imports
from chainlib.jsonrpc import JSONRPCRequest
from chainlib.block import Block as BaseBlock
from hexathon import (
        add_0x,
        strip_0x,
        even,
        )

# local imports
from chainlib.eth.tx import Tx


def block_latest(id_generator=None):
    j = JSONRPCRequest(id_generator)
    o = j.template()
    o['method'] = 'eth_blockNumber'
    return j.finalize(o)


def block_by_hash(hsh, include_tx=True, id_generator=None):
    j = JSONRPCRequest(id_generator)
    o = j.template()
    o['method'] = 'eth_getBlockByHash'
    o['params'].append(hsh)
    o['params'].append(include_tx)
    return j.finalize(o)


def block_by_number(n, include_tx=True, id_generator=None):
    nhx = add_0x(even(hex(n)[2:]))
    j = JSONRPCRequest(id_generator)
    o = j.template()
    o['method'] = 'eth_getBlockByNumber'
    o['params'].append(nhx)
    o['params'].append(include_tx)
    return j.finalize(o)


def transaction_count(block_hash, id_generator=None):
    j = JSONRPCRequest(id_generator)
    o = j.template()
    o['method'] = 'eth_getBlockTransactionCountByHash'
    o['params'].append(block_hash)
    return j.finalize(o)


class Block(BaseBlock):
    
    def __init__(self, src):
        self.hash = src['hash']
        try:
            self.number = int(strip_0x(src['number']), 16)
        except TypeError:
            self.number = int(src['number'])
        self.txs = src['transactions']
        self.block_src = src
        try:
            self.timestamp = int(strip_0x(src['timestamp']), 16)
        except TypeError:
            self.timestamp = int(src['timestamp'])
