# external imports
import sha3
from hexathon import add_0x
from crypto_dev_signer.eth.transaction import EIP155Transaction

# local imports
from chainlib.hash import (
        keccak256_hex_to_hex,
        keccak256_string_to_hex,
        )
from .constant import ZERO_ADDRESS
from .tx import TxFactory
from .contract import (
        ABIContractEncoder,
        ABIContractType,
        )
from chainlib.jsonrpc import jsonrpc_template
        

class ERC20(TxFactory):
    

    def balance(self, contract_address, address, sender_address=ZERO_ADDRESS):
        o = jsonrpc_template()
        o['method'] = 'eth_call'
        enc = ABIContractEncoder()
        enc.method('balanceOf')
        enc.typ(ABIContractType.ADDRESS)
        enc.address(address)
        data = add_0x(enc.get())
        tx = self.template(sender_address, contract_address)
        tx = self.set_code(tx, data)
        o['params'].append(self.normalize(tx))
        o['params'].append('latest')
        return o


    def decimals(self, contract_address, sender_address=ZERO_ADDRESS):
        o = jsonrpc_template()
        o['method'] = 'eth_call'
        enc = ABIContractEncoder()
        enc.method('decimals')
        data = add_0x(enc.get())
        tx = self.template(sender_address, contract_address)
        tx = self.set_code(tx, data)
        o['params'].append(self.normalize(tx))
        o['params'].append('latest')
        return o


    def transfer(self, contract_address, sender_address, recipient_address, value):
        enc = ABIContractEncoder()
        enc.method('transfer')
        enc.typ(ABIContractType.ADDRESS)
        enc.typ(ABIContractType.UINT256)
        enc.address(recipient_address)
        enc.uint256(value)
        data = add_0x(enc.get())
        tx = self.template(sender_address, contract_address, use_nonce=True)
        tx = self.set_code(tx, data)
        return self.build(tx)
