# standard imports
import uuid

# local imports
from .error import JSONRPCException


class UUIDGenerator:

    def next(self):
        return str(uuid.uuid4())


class IntSequenceGenerator:

    def __init__(self, start=0):
        self.id = start

    def next(self):
        next_id = self.id
        self.id += 1
        return next_id

default_id_generator = UUIDGenerator()


class DefaultErrorParser:

    def translate(self, error):
        return JSONRPCException('default parser code {}'.format(error))


class JSONRPCRequest:

    def __init__(self, id_generator=default_id_generator):
        if id_generator == None:
            id_generator = default_id_generator
        self.id_generator = id_generator


    def template(self):
        return {
            'jsonrpc': '2.0',
            'id': None,
            'method': None,
            'params': [],
                }


    def finalize(self, request):
        request['id'] = self.id_generator.next()
        return request


def jsonrpc_response(request_id, result):
        return {
            'jsonrpc': '2.0',
            'id': request_id,
            'result': result,
            }


def jsonrpc_error(request_id, code=-32000, message='Server error'):
        return {
            'jsonrpc': '2.0',
            'id': request_id,
            'error': {
                'code': code,
                'message': message,
                },
            }


def jsonrpc_result(o, ep):
    if o.get('error') != None:
        raise ep.translate(o)
    return o['result']


