# standard imports
import enum
import os


script_dir = os.path.dirname(os.path.realpath(__file__))
default_config_dir = os.path.join(script_dir, '..', 'data', 'config')


class Flag(enum.IntEnum):
    # read
    VERBOSE = 1
    CONFIG = 2
    RAW = 4
    ENV_PREFIX = 8
    PROVIDER = 16
    CHAIN_SPEC = 32
    UNSAFE = 64
    SEQ = 128
    # write 
    KEY_FILE = 256
    SEND = 512
    SIGN = 1024
    WAIT = 2048

argflag_std_read = 0x0fff 
argflag_std_write = 0xffff
