# standard imports
import logging

# external imports
import confini

# local imports
from .base import (
        Flag,
        default_config_dir,
        )


class Config(confini.Config):

    @staticmethod
    def from_args(args, arg_flags, extra_args={}, config_dir=None, logger=None):

        if logger == None:
            logger = logging.getLogger()

        if args.vv:
            logger.setLevel(logging.DEBUG)
        elif args.v:
            logger.setLevel(logging.INFO)

        if config_dir == None:
            config_dir = default_config_dir
        override_config_dirs = []
        if getattr(args, 'config', None) != None:
            override_config_dirs.append(args.config)
        env_prefix = getattr(args, 'env_prefix', None)
        config = confini.Config(config_dir, env_prefix=args.env_prefix, override_dirs=override_config_dirs)
        config.process()

        args_override = {}

        if arg_flags & Flag.PROVIDER:
            args_override['RPC_HTTP_PROVIDER'] = getattr(args, 'p')
        if arg_flags & Flag.CHAIN_SPEC:
            args_override['CHAIN_SPEC'] = getattr(args, 'i')
        if arg_flags & Flag.KEY_FILE:
            args_override['WALLET_KEY_FILE'] = getattr(args, 'y')
       
        config.dict_override(args_override, 'cli args')

        if arg_flags & Flag.UNSAFE:
            config.add(getattr(args, 'u'), '_UNSAFE')
        if arg_flags & Flag.SEND:
            config.add(getattr(args, 'fee_limit'), '_FEE_LIMIT')
            config.add(getattr(args, 'fee_price'), '_FEE_PRICE')
            config.add(getattr(args, 'nonce'), '_NONCE')
            config.add(getattr(args, 'recipient'), '_RECIPIENT')
            config.add(getattr(args, 's'), '_RPC_SEND')
            config.add(getattr(args, 'raw'), '_RAW')
        if arg_flags & Flag.SEQ:
            config.add(getattr(args, 'seq'), '_SEQ')

        for k in extra_args.keys():
            v = extra_args[k]
            if v == None:
                v = k.upper()
            config.add(getattr(args, k), '_' + v)

        logger.debug('config loaded:\n{}'.format(config))
        return config
