# standard imports
import logging
import os

# external imports
import confini

# local imports
from .base import (
        Flag,
        default_config_dir as default_parent_config_dir,
        )

logg = logging.getLogger(__name__)


class Config(confini.Config):

    default_base_config_dir = default_parent_config_dir

    @classmethod
    def from_args(cls, args, arg_flags, extra_args={}, default_config_dir=None, base_config_dir=None, logger=None):

        if logger == None:
            logger = logging.getLogger()

        if args.vv:
            logger.setLevel(logging.DEBUG)
        elif args.v:
            logger.setLevel(logging.INFO)

        override_config_dirs = []

        config_dir = [cls.default_base_config_dir]
        if base_config_dir != None:
            logg.debug('have explicit base config addition {}'.format(base_config_dir))
            if isinstance(base_config_dir, str):
                base_config_dir = [base_config_dir]
            for d in base_config_dir:
                config_dir.append(d)
            logg.debug('processing config dir {}'.format(config_dir))

        # confini dir env var will be used for override configs only in this case
        if default_config_dir == None:
            default_config_dir = os.environ.get('CONFINI_DIR')

        # process config command line argument
        if getattr(args, 'config', None) != None:
            if config_dir == None:
                config_dir = [cls.default_base_config_dir, args.config]
                logg.debug('using config arg as base config addition {}'.format(args.config))
            else:
                override_config_dirs.append(args.config)
                logg.debug('using config arg as config override {}'.format(args.config))

        # 
        if config_dir == None:
            if default_config_dir == None:
                default_config_dir = default_parent_config_dir
            config_dir = default_config_dir
        env_prefix = getattr(args, 'env_prefix', None)
        config = confini.Config(config_dir, env_prefix=args.env_prefix, override_dirs=override_config_dirs)
        config.process()

        args_override = {}

        if arg_flags & Flag.PROVIDER:
            args_override['RPC_HTTP_PROVIDER'] = getattr(args, 'p')
        if arg_flags & Flag.CHAIN_SPEC:
            args_override['CHAIN_SPEC'] = getattr(args, 'i')
        if arg_flags & Flag.KEY_FILE:
            args_override['WALLET_KEY_FILE'] = getattr(args, 'y')
       
        config.dict_override(args_override, 'cli args')

        if arg_flags & Flag.UNSAFE:
            config.add(getattr(args, 'u'), '_UNSAFE')
        if arg_flags & Flag.SEND:
            config.add(getattr(args, 'fee_limit'), '_FEE_LIMIT')
            config.add(getattr(args, 'fee_price'), '_FEE_PRICE')
            config.add(getattr(args, 'nonce'), '_NONCE')
            config.add(getattr(args, 'recipient'), '_RECIPIENT')
            config.add(getattr(args, 's'), '_RPC_SEND')
            config.add(getattr(args, 'raw'), '_RAW')
        if arg_flags & Flag.SEQ:
            config.add(getattr(args, 'seq'), '_SEQ')

        for k in extra_args.keys():
            v = extra_args[k]
            if v == None:
                v = '_' + k.upper()
            config.add(getattr(args, k), v, exists_ok=True)

        logger.debug('config loaded:\n{}'.format(config))
        return config
