# standard imports
import enum
import os


script_dir = os.path.dirname(os.path.realpath(__file__))

default_config_dir = os.path.join(script_dir, '..', 'data', 'config')


# powers of two
class Flag(enum.IntEnum):
    # read
    VERBOSE = 1
    CONFIG = 2
    RAW = 4
    ENV_PREFIX = 8
    PROVIDER = 16
    CHAIN_SPEC = 32
    UNSAFE = 64
    SEQ = 128
    # read/write
    KEY_FILE = 256
    # write
    SEND = 4096
    SIGN = 8192
    EXEC = 16384
    WALLET = 32768
    # sendmode
    WAIT = 65536
    WAIT_ALL = 131072


argflag_std_read = 0x0fff 
argflag_std_write = 0xff3fff
argflag_std_base = 0x000f
argflag_std_target = 0x00c000
