# standard imports
import logging

logg = logging.getLogger(__name__)


class ChainInterface:

    interface_name = 'custom'

    def __unimplemented(*args, **kwargs):
        raise NotImplementedError()

    def __init__(self):
        self._block_latest = self.__unimplemented
        self._block_by_hash = self.__unimplemented
        self._block_by_number = self.__unimplemented
        self._block_from_src = self.__unimplemented
        self._block_to_src = self.__unimplemented
        self._tx_by_hash = self.__unimplemented
        self._tx_by_block = self.__unimplemented
        self._tx_receipt = self.__unimplemented
        self._tx_raw = self.__unimplemented
        self._tx_pack = self.__unimplemented
        self._tx_unpack = self.__unimplemented
        self._tx_from_src = self.__unimplemented
        self._tx_to_src = self.__unimplemented
        self._address_safe = self.__unimplemented
        self._address_normal = self.__unimplemented
        self._src_normalize = self.__unimplemented


    def block_latest(self):
        return self._block_latest()


    def block_by_hash(self, hsh):
        return self._block_by_hash(hsh)


    def block_by_number(self, idx):
        return self._block_by_number(idx)


    def block_from_src(self, src):
        return self._block_from_src(src)


    def block_to_src(self, block):
        return self._block_to_src()


    def tx_by_hash(self, hsh):
        return self._tx_by_hash(hsh)


    def tx_by_block(self, hsh, idx):
        return self._tx_by_block(hsh, idx)


    def tx_receipt(self, hsh):
        return self._tx_receipt(hsh)


    def tx_raw(self, data):
        return self._tx_raw(data)


    def tx_pack(self, tx, chain_spec):
        return self._tx_pack(tx, chain_spec)


    def tx_unpack(self, data, chain_spec):
        return self._tx_unpack(data, chain_spec)


    def tx_from_src(self, src, block=None):
        return self._tx_from_src(src, block)


    def tx_to_src(self, tx):
        return self._tx_to_src(tx)


    def address_safe(self, address):
        return self._address_safe(address)


    def address_normal(self, address):
        return self._address_normal(address)


    def src_normalize(self, src):
        return self._src_normalize(src)


    def set(self, method, target):
        imethod = '_' + method
        if not hasattr(self, imethod):
            raise AttributeError('invalid method {}'.format(imethod))
        setattr(self, imethod, target)
        logg.debug('set method {} on interface {}'.format(method, self.interface_name))
