# local imports
from chainqueue.enum import StatusBits


class Adapter:

    def __init__(self, backend):
        self.backend = backend


    def add(self, bytecode, chain_spec, session=None):
        raise NotImplementedEror()


    def translate(self, bytecode, chain_spec):
        raise NotImplementedEror()


    def dispatch(self, chain_spec, rpc, tx_hash, signed_tx, session=None):
        raise NotImplementedEror()


    def upcoming(self, chain_spec, session=None):
        raise NotImplementedEror()


    def create_session(self, session=None):
        return self.backend.create_session(session)


    def release_session(self, session=None):
        return self.backend.release_session(session)

