# standard imports
import logging

# local imports
from cic_auth.auth import Auth


class AfricasTalking(Auth):
    """Handles the authentication paramteres used by the AfricasTalking USSD callback.

    :param fetcher: Callback used to retrieve authentication data based on the authorization string digest
    :type fetcher: function
    :param auth_string: Username and password.
    :type auth_string: sstr
    """
    component_id = 'atquerystring'
    logger = logging.getLogger(__name__)


    def __init__(self, fetcher, auth_string, ips):
        self.ips = ips
        super(AfricasTalking, self).__init__(fetcher, auth_string)


    def check(self):
        """Implements Auth.check
        """
        self.logger.debug('africastalking check')
        if self.current_ip not in self.ips:
            self.logger.info('africastalking ip {} not in whitelist'.format(self.current_ip))
            return None
        if self.auth_string == None:
            self.logger.debug('no authstring found')
            return None
        auth_data = self.retriever.load(self.auth_string)
        if auth_data == None:
            return None
        return (self.component_id, self.auth_string, auth_data)
