# CIC-AUTH

Authentication module for humans and machines interacting with CIC services.


## OVERVIEW

This module provides

- Direct authentication through HTTP Authorization and SSL client certificates.
- Pluggable direct authentiation extensions
- HTTP UWSGI application implementing Oauth authorization flow

Authentication is performed by authenticator objects implementing the `cic_eth.Auth` interface. Their role is to:

- Transform the credentials provided as input to a deterministic identifier
- Call a backend wuth deterministic identifier to retrieve the authentication data

The backend is provided as an argument to the authenticators, leaving the implementation of authentication data retrieval (along with decryption, verification) up to the front-end implementer. 


## USAGE

Self-explanatory examples can be found in `examples/server.py` and `example/client_\*.py`

And example client SSL certificate is also provided (the key has password `test`).

To run the example server, make sure the uwsgi python plugin is installed. Change directory to `/example`, then execute:

`PYTHONPATH=.. uwsgi --wsgi-file server.py --ini uwsgi.ini`
