class Auth:

    component_id = None

    """Base class and interface for authentication backends

    :param retriever: Retriever object to access authentication data
    :type retriever: function
    :param auth_string: Authentication string
    :type auth_string: str
    :param realm: Authentication realm, optional
    :type realm: str
    """
    def __init__(self, retriever, auth_string, realm=None):
        self.retriever = retriever
        self.auth_string = auth_string
        self.realm = realm

    """Interface method.

    In implementation it should execute the authentication lookup with the current state of data.

    :returns: None on failure, or tuple (authentication component id, authentication string, authentication data)
    :rtype: tuple or None
    """
    def check(self):
        return None


    """Returns the WWW-Authenticate value the implemented authentication backend.

    :returns: Challenge string, if applicable
    :rtype: str or None
    """
    def method(self):
        return None
