# standard imports
import urllib.request
from http.client import HTTPResponse
import os
from email.utils import unquote
import datetime
import logging
import re

logg = logging.getLogger(__name__)


def split_auth_header(v):
    subsections = v.split(',')
    logg.debug('subs {}'.format(subsections))
    parts = {}
    for s in subsections:
        (k, v) = s.split('=', maxsplit=1)
        parts[k] = unquote(v)
    return parts 


def split_challenge_header(v, strict=True):
    o = split_auth_header(v)
    if o.get('challenge') == None:
        raise ValueError('challenge missing')
    elif strict:
        if o.get('max-age') == None or o.get('realm') == None:
            raise ValueError('strict parse fail') 
    return o


def challenge_nonce():
    return os.urandom(32)


re_auth = r'^(\w+) (.+)$'
class ClientSession(urllib.request.BaseHandler):

    def __init__(self, origin):
        super(ClientSession, self).__init__()
        self.session_token = None
        self.session_date = None
        self.origin = origin

    def set_token(self, token):
        logg.debug('setting auth token {}'.format(token))
        self.session_token = token
        self.session_date = datetime.datetime.utcnow()


    def http_request(self, request):
        if request.headers.get('Authorization') == None:
            logg.debug('auth set token {}'.format(self.session_token))
            if self.session_token != None:
                request.headers['Authorization'] = 'Bearer {}'.format(self.session_token)
        return request


    def http_error_401(self, request, response, code, msg, hdrs):
        h = hdrs.get('WWW-Authenticate')
        if h != None:
            m = re.match(re_auth, h)
            method = m.group(1)
            details = m.group(2)
            logg.debug('auth method {} requested with: {}'.format(method, details))
            if method == 'HOBA':
                hoba_result = self.process_auth_challenge(details, method=method)
                auth_response = str(hoba_result)
                logg.debug('auth response {}'.format(auth_response))

                request.headers['Authorization'] = '{} {}'.format(method, auth_response)
                opener = urllib.request.build_opener(self)
                response = None
                try:
                    response = opener.open(request)
                except urllib.error.HTTPError as e:
                    logg.error('unexpected status code from auth: {}'.format(e))

                #logg.debug('set token 401')
                #self.set_token(hdrs.get('Token'))

        return response


    def http_error_403(self, request, response, code, msg, hdrs):
            if self.session_token == None:
                self.set_token(hdrs.get('Token'))
    
            return response


    def process_auth_challenge(self, header, encoding=None, method=None):
        raise NotImplementedError('override this class to create an auth challenge handler for authorization method {}'.format(method))
