# standard imports
import logging

# external imports
from http_token_auth import SessionStore
from http_token_auth.error import ExpiredError

# local imports
from cic_auth.filter import Filter

logg = logging.getLogger(__name__)


class SessionFilter(Filter):

    default_name = 'session filter'

    def __init__(self, session_store, name=None):
        super(SessionFilter, self).__init__(name=name)
        self.session_store = session_store


    def decode(self, requested_ip, v, signature=None, identity=None):
        session = None
        if identity == None:
            identity = v
        try:
            session = self.session_store.get(identity)
            return (session.identity, signature, identity)
        except ExpiredError:
            logg.debug('token expired: {}'.format(identity))
            return None
        except KeyError:
            pass

        if session == None:
            self.session_store.new(identity)
            return (v, signature, identity)

        return None
