#!python3

# SPDX-License-Identifier: GPL-3.0-or-later

# standard imports
import logging
import argparse
import os
import json

# external imports
import confini
import celery

# local imports
import cic_cache.cli
from cic_cache.api import Api

logging.basicConfig(level=logging.WARNING)
logg = logging.getLogger()

arg_flags = cic_cache.cli.argflag_std_base
local_arg_flags = cic_cache.cli.argflag_local_task
argparser = cic_cache.cli.ArgumentParser(arg_flags)
argparser.add_argument('--offset', default=0, type=int, help='Result index offset')
argparser.add_argument('--limit', default=100, type=int, help='Maximum number of results')
argparser.add_argument('--block-offset', dest='block_offset',type=int, help='Block index offset')
argparser.add_argument('--block-limit', dest='block_limit', type=int, help='Block index limit')
argparser.add_positional('address', type=str, required=False, help='Get results involving given address only')
argparser.process_local_flags(local_arg_flags)
args = argparser.parse_args()

extra_args = {
    'block_offset': None,
    'block_limit': None,
    'offset': None,
    'limit': None,
    'address': None,
        }
config = cic_cache.cli.Config.from_args(args, arg_flags, local_arg_flags, extra_args=extra_args)

celery_app = cic_cache.cli.CeleryApp.from_config(config)

api = Api(queue=config.get('CELERY_QUEUE'))


def main():
    address = config.get('_ADDRESS')
    logg.debug('running list content offset {} limit {} address {} block offset {} block limit {}'.format(config.get('_OFFSET'), config.get('_LIMIT'), address, config.get('_BLOCK_OFFSET'), config.get('_BLOCK_LIMIT')))
    t = api.list_content(config.get('_OFFSET'), config.get('_LIMIT'), address=address, block_offset=config.get('_BLOCK_OFFSET'), block_limit=config.get('_BLOCK_LIMIT'))
    r = t.get_leaf()
    logg.info('match low {} high {}'.format(r[0], r[1]))
    for tx in r[2]:
        print(tx)

#    block_filter = bytes.from_hex(o['block_filter'])
#    block_tx_filter = bytes.from_hex(o['block_tx_filter'])
#    f_block = moolb.Bloom(len(block_filter), o['filter_rounds'])
#    f_block_tx = moolb.Bloom(len(block_tx_filter), o['filter_rounds'])
#    
#    for i in range(o['low'], o['high']):
#        if f_block.check(i):
#        for j in range(200):
#            if f_block.check(j):

    
if __name__ == '__main__':
    main()
