# standard imports
import logging

# external imports
from contract_registry.registry import Registry
from chainlib.eth.constant import ZERO_ADDRESS

# local imports
from .error import UnknownContractError
#logg = logging.getLogger(__name__)
logg = logging.getLogger()


class CICRegistry:

    address = None
    lookup = []

    def __init__(self, chain_spec, rpc):
        self.chain_spec = chain_spec
        self.rpc = rpc


    def registry_lookup(self, name, sender_address=ZERO_ADDRESS):
        c = Registry()
        o = c.address_of(self.address, name, sender_address=sender_address)
        r = self.rpc.do(o)
        address = c.parse_address_of(r)
        return address


    @staticmethod
    def add_lookup(lookup):
        CICRegistry.lookup.append(lookup)


    def by_name(self, name, sender_address=ZERO_ADDRESS):
        for lookup in self.lookup:
            logg.debug('executing lookup {} for name {}'.format(str(lookup), name))
            address = lookup.by_name(self.rpc, name, sender_address)
            if address != ZERO_ADDRESS:
                logg.info('lookup {} found {} for name {}'.format(str(lookup), address, name))
                return address

        address = self.registry_lookup(name, sender_address)
        logg.debug('executing fallback lookup for name {}'.format(name))
        if address == ZERO_ADDRESS:
            raise UnknownContractError((str(self.chain_spec), name,))
        logg.info('fallback lookup found {} for name {}'.format(address, name))

        return address


    def by_address(self, address, sender_address=ZERO_ADDRESS):
        return None
