# external imports
from chainlib.eth.erc20 import ERC20
from chainlib.connection import RPCConnection

# local imports
from cic_eth_registry.cache.base import CacheObject
from cic_eth_registry.base import QueryBase


class ERC20TokenCacheObject(CacheObject):

    def __init__(self, address):
        super(ERC20TokenCacheObject, self).__init__('erc20', address, ['name', 'symbol', 'decimals'])


class ERC20Token(QueryBase):

    def __init__(self, rpc, address):
        self.o = ERC20TokenCacheObject(address)

        if self.o.cache_date == None:
            self.load(rpc)


    def load(self, rpc):
        c = ERC20()
        o = c.name(self.o.address, sender_address=self.caller_address)
        r = rpc.do(o)
        self.o.name = c.parse_name(r)

        o = c.symbol(self.o.address, sender_address=self.caller_address)
        r = rpc.do(o)
        self.o.symbol = c.parse_symbol(r)

        o = c.decimals(self.o.address, sender_address=self.caller_address)
        r = rpc.do(o)
        self.o.decimals = c.parse_decimals(r)


    @property
    def name(self):
        return self.o.name


    @property
    def symbol(self):
        return self.o.symbol


    @property
    def decimals(self):
        return self.o.decimals
