# external imports
from chainlib.eth.constant import ZERO_ADDRESS
from eth_token_index import TokenUniqueSymbolIndex

# local imports
from .base import Lookup


class TokenIndexLookup(Lookup):

    def __init__(self, token_index_address):
        self.address = token_index_address


    def by_name(self, rpc, token_symbol, sender_address=ZERO_ADDRESS):
        c = TokenUniqueSymbolIndex()
        o = c.address_of(self.address, token_symbol, sender_address=sender_address)
        r = rpc.do(o)
        return c.parse_address_of(r)

    def __str__(self):
        return 'token index lookup'
