# standard imports
import logging

# local imports
from cic_eth.db.models.role import AccountRole
from cic_eth.db.models.base import SessionBase

logg = logging.getLogger()


class GasOracle():
    """GasOracle

    This is a temporary hard-coded 
    """
    __safe_threshold_amount_value = 2000000000 * 60000 * 3
    __refill_amount_value = __safe_threshold_amount_value * 5
    default_gas_limit = 21000

    def __init__(self, w3):
        self.w3 = w3


    @staticmethod
    def set_provider_address(address):
        logg.info('setting gas provider {}'.format(address))
        GasOracle.gas_provider_address = address
        session = SessionBase.create_session()
        role = AccountRole.set('GAS_GIFTER', address)
        session.add(role)
        session.commit()
        session.close()


    def safe_threshold_amount(self):
        g = GasOracle.__safe_threshold_amount_value
        logg.warning('gas safe threshold is currently hardcoded to {}'.format(g))
        return g


    def refill_amount(self):
        g = GasOracle.__refill_amount_value
        logg.warning('gas refill amount is currently hardcoded to {}'.format(g))
        return g

 
    def gas_provider(self):
        return AccountRole.get_address('GAS_GIFTER')


    def gas_price(self, category='safe'):
        logg.warning('gas price hardcoded to category "safe"')
        #g = self.w3.eth.gasPrice 
        g = 100
        return g
