# third-party imports
from sqlalchemy import Column, String, Text
from cic_registry import zero_address

# local imports
from .base import SessionBase


class AccountRole(SessionBase):
    __tablename__ = 'account_role'

    tag = Column(Text)
    address_hex = Column(String(42))


    @staticmethod
    def get_address(tag):
        role = AccountRole.get_role(tag)
        if role == None:
            return zero_address
        return role.address_hex


    @staticmethod
    def get_role(tag):
        session = AccountRole.create_session()
        role = AccountRole.__get_role(session, tag)
        session.close()
        #return role.address_hex
        return role


    @staticmethod
    def __get_role(session, tag):
        return session.query(AccountRole).filter(AccountRole.tag==tag).first()


    @staticmethod    
    def set(tag, address_hex):
        #session = AccountRole.create_session()
        #role = AccountRole.__get(session, tag)
        role = AccountRole.get_role(tag) #session, tag)
        if role == None:
            role = AccountRole(tag)
        role.address_hex = address_hex
        #session.add(role)
        #session.commit()
        #session.close()
        return role #address_hex


    def __init__(self, tag):
        self.tag = tag
        self.address_hex = zero_address
