# standard imports
import logging

# third-party imports
from sqlalchemy import Column, String, Integer

# local imports
from .base import SessionBase

logg = logging.getLogger()


class Nonce(SessionBase):
    __tablename__ = 'nonce'

    nonce = Column(Integer)
    address_hex = Column(String(42))


    @staticmethod
    def __get(conn, address):
        r = conn.execute("SELECT nonce FROM nonce WHERE address_hex = '{}'".format(address))
        nonce = r.fetchone()
        if nonce == None:
            return None
        return nonce[0]


    @staticmethod
    def __set(conn, address, nonce):
        conn.execute("UPDATE nonce set nonce = {} WHERE address_hex = '{}'".format(nonce, address))


    @staticmethod
    def next(address, initial_if_not_exists=0):
        conn = Nonce.engine.connect()
        if Nonce.transactional:
            conn.execute('BEGIN')
            conn.execute('LOCK TABLE nonce IN SHARE ROW EXCLUSIVE MODE')
        nonce = Nonce.__get(conn, address)
        logg.debug('get nonce {} for address {}'.format(nonce, address))
        if nonce == None:
            nonce = initial_if_not_exists
            conn.execute("INSERT INTO nonce (nonce, address_hex) VALUES ({}, '{}')".format(nonce, address))
            logg.debug('setting default nonce to {} for address {}'.format(nonce, address))
        Nonce.__set(conn, address, nonce+1)
        if Nonce.transactional:
            conn.execute('COMMIT')
        conn.close()
        return nonce


