# TODO: extend blocksync model
class Syncer:
    """Base class and interface for implementing a block sync poller routine.

    :param bc_cache: Retrieves block cache cursors for chain head and latest processed block.
    :type bc_cache: object implementing methods head(height) and backlog(height)
    """
    w3 = None
    running_global = True

    def __init__(self, bc_cache):
        self.cursor = None
        self.bc_cache = bc_cache
        self.filter = []
        self.running = True


    def chain(self):
        return self.bc_cache.chain()


    def get(self):
        """Get latest unprocessed blocks.

        :returns: list of block hash strings
        :rtype: list
        """
        raise NotImplementedError()


    def process(self, w3, ref):
        """Process transactions in a single block.

        :param ref: Reference of object to process
        :type ref: str, 0x-hex
        """
        raise NotImplementedError()


    def loop(self, interval):
        """Entry point for syncer loop

        :param interval: Delay in seconds until next attempt if no new blocks are found.
        :type interval: int
        """
        raise NotImplementedError()
