# third-party imports
from sqlalchemy import Column, Enum, String, Integer
from sqlalchemy.ext.hybrid import hybrid_method

# local imports
from .base import SessionBase
from ..error import UnknownConvertError


class TxConvertTransfer(SessionBase):
    __tablename__ = 'tx_convert_transfer'

    #approve_tx_hash = Column(String(66))
    convert_tx_hash = Column(String(66))
    transfer_tx_hash = Column(String(66))
    recipient_address = Column(String(42))

    
    @hybrid_method
    def transfer(self, transfer_tx_hash):
        self.transfer_tx_hash = transfer_tx_hash


    @staticmethod
    def get(convert_tx_hash):
        q = TxConvertTransfer.session.query(TxConvertTransfer)
        q = q.filter(TxConvertTransfer.convert_tx_hash==convert_tx_hash)
        r = q.first()
        if r == None:
            raise UnknownConvertError(convert_tx_hash)
        return r


#    @hybrid_method
#    def convert(self, convert_tx_hash):
#        self.convert_tx_hash = convert_tx_hash
#

    def __init__(self, convert_tx_hash, recipient_address):
        self.convert_tx_hash = convert_tx_hash
        self.recipient_address = recipient_address
