# local imports
import logging

# third-party imports
from sqlalchemy.sql import func

# local imports 
from cic_eth.db.models.base import SessionBase

logg = logging.getLogger()


__list_fields =  [
        'is_sender',
        'is_pending',
        'is_convert',
        'is_synced',
        'is_success',
        'cache_id',
        'sender',
        'recipient',
        'origin',
	'state',
	'source_token_address',
	'destination_token_address',
	'from_value',
	'to_value',
	'block_number',
	'tx_number',
        'nonce',
        'date_registered',
        ]


def row_to_dict(row):
    d = {}
    for i in range(len(row)):
        #logg.debug('len {} {}'.format(__list_fields[i], row[i]))
        d[__list_fields[i]] = row[i]
    return d


def list_balances(holder_address, token_address):
    session = SessionBase.create_session()

    # sqlalchemy session.execute literal sql returns bogus, and sqlalchemy.sql.func returns a string representation of the results
    # this reverting to lowlevel conn for stored procedure
    conn = SessionBase.engine.raw_connection()
    cursor = conn.cursor()
    cursor.execute("SELECT * from balances('{}', '{}')".format(holder_address, token_address))
    r = cursor.fetchone()
    conn.close()
    return r


def list_transactions(holder_address, offset, limit):
    session = SessionBase.create_session()

    # sqlalchemy session.execute literal sql returns bogus, and sqlalchemy.sql.func returns a string representation of the results
    # this reverting to lowlevel conn for stored procedure
    conn = SessionBase.engine.raw_connection()
    cursor = conn.cursor()
    cursor.execute("SELECT * from transaction_list('{}', {}, {})".format(holder_address, offset, limit))
    r = cursor.fetchall()
    conn.close()
    return r

