# standard imports
import logging
import multiprocessing
import types
import re

# local imports
from crypto_dev_signer.eth.web3ext import Web3

logg = logging.getLogger()


class GasOracle():
    """GasOracle
    """
    __safe_threshold_amount_value = 1000000000000000
    __refill_amount_value = __safe_threshold_amount_value
    gas_provider_address = None
    default_gas_limit = 21000


    @staticmethod
    def set_provider_address(address):
        GasOracle.gas_provider_address = address         


    def safe_threshold_amount(self):
        g = GasOracle.__safe_threshold_amount_value
        logg.warning('gas safe threshold is currently hardcoded to {}'.format(g))
        return g


    def refill_amount(self):
        g = GasOracle.__refill_amount_value
        logg.warning('gas refill amount is currently hardcoded to {}'.format(g))
        return g

 
    def gas_provider(self):
        return self.gas_provider_address

  
class RpcClient(GasOracle):
    signer_ipc_path = None
    provider_url = None
    web3_constructor = None


    def __init__(self, holder_address=None): #, provider_url, signer_ipc_path='/run/crypto-dev-signer/jsonrpc.ipc'):
        (self.provider, self.w3) = RpcClient.web3_constructor() #provider_url, signer_ipc_path)
        if holder_address != None:
            self.holder_address = holder_address
            self.nonce = self.w3.eth.getTransactionCount(self.holder_address, 'pending')
            logg.info('"pending" nonce {} for address {}'.format(self.nonce, self.holder_address))
            self.gas_price = self.gas_price(self.w3)
            logg.info('gasprice {}'.format(self.gas_price))


    def gas_price(self, category='safe'):
        logg.warning('gas price hardcoded to category "safe"')
        g = self.w3.eth.gasPrice 
        return g


    @staticmethod
    def set_constructor(web3_constructor):
        RpcClient.web3_constructor = web3_constructor
