# standard imports
import logging

# third-party imports
from web3.exceptions import BlockNotFound
from .error import SyncDone

# local imports
from .mined import MinedSyncer
from .base import Syncer

logg = logging.getLogger()


class HistorySyncer(MinedSyncer):
    """Implements the get method in Syncer for retrieving all blocks between last processed block before previous shutdown and block height at time of syncer start.

    :param bc_cache: Retrieves block cache cursors for chain head and latest processed block.
    :type bc_cache: object implementing methods head(height) and backlog(height)
    :param mx: Maximum number of blocks to return in one call
    :type mx: int
    """
    def __init__(self, bc_cache, mx=20):
        super(HistorySyncer, self).__init__(bc_cache)
        self.max = mx
        self.lower = self.bc_cache.backlog()
        self.last = self.lower
        self.filter = []

    """Implements Syncer.get

    BUG: Should also raise SyncDone when block array is empty after loop.

    :raises SyncDone: If a block is not found.
    """
    def get(self):
        if not Syncer.running:
            raise SyncDone(self.last)
        b = []
        target = self.last + self.max
        logg.debug('taget {} {} {}'.format(target, self.last, self.max))
        for i in range(self.last, target):
            try:
                b.append(Syncer.w3.eth.getBlock(i).hash)
                logg.debug('appending block {}'.format(b))
                self.last = i
            except BlockNotFound:
                logg.info('block {} not found, exiting block retrieve loop'.format(i))
                if i == self.last+1:
                    Syncer.running = False
                self.last = i
                break
        return b

