# standard imports
import logging

# third-party imports
import celery

# local impotes
from .base import Syncer
from cic_eth.queue.tx import set_final_status

app = celery.current_app
logg = logging.getLogger()


class MinedSyncer(Syncer):
    """Base implementation of block processor for mined blocks.

    Loops through all transactions, 

    :param block_hash_hex: Block hash
    :type block_hash_hex: str, 0x-hash
    """
    def process(self, w3, block_hash_hex):
        logg.debug('processing {}'.format(block_hash_hex))
        b = w3.eth.getBlock(block_hash_hex)
        c = w3.eth.getBlockTransactionCount(block_hash_hex)
        for i in range(c):
            tx = w3.eth.getTransactionByBlock(block_hash_hex, i)
            tx_hash_hex = tx['hash'].hex()
            rcpt = w3.eth.getTransactionReceipt(tx_hash_hex)
            logg.debug('{}/{} processing tx {} from block {}'.format(i+1, c, tx_hash_hex, block_hash_hex))
            s = celery.signature(
                    'set_final_status',
                    [tx_hash_hex, rcpt['blockNumber'], not rcpt['status']],
                    )
            s.apply_async()
            for f in self.filter:
                #try:
                f(w3, tx, rcpt)
                #except Exception as e:
                #logg.debug(e)
        return b['number']

