class TokenCountError(Exception):
    """Exception raised when wrong number of tokens have been given to a task
    """
    pass


class NotLocalTxError(Exception):
    """Exception raised when trying to access a tx not originated from a local task
    """
    pass


class PermanentTxError(Exception):
    """Exception raised when encountering a permanent error when sending a tx.

    - wrong nonce
    - insufficient balance
    """
    pass


class TemporaryTxError(Exception):
    """Exception raised when encountering a permanent error when sending a tx.

    - blockchain node connection
    """
    pass

class OutOfGasError(Exception):
    """Exception raised when a transaction task must yield pending gas refill for an account

    """
    pass
