# standard imports
import logging
import sha3
import web3

# third-party imports
from cic_registry import ContractRegistry
from rlp import decode as rlp_decode
from rlp import encode as rlp_encode
from eth_keys import KeyAPI

logg = logging.getLogger()


def unpack_signed_raw_tx(tx_raw_bytes, chain_id):
    d = rlp_decode(tx_raw_bytes)

    for i in d:
        logg.debug('decoded {} chainid {}'.format(i.hex(), chain_id))
    v = int.from_bytes(d[6], 'big')
    vb = v - (chain_id * 2) - 35
    s = b''.join([d[7], d[8], bytes([vb])])
    so = KeyAPI.Signature(signature_bytes=s)

    d[6] = chain_id
    d[7] = b''
    d[8] = b''
    h = sha3.keccak_256()
    h.update(rlp_encode(d))
    z = h.digest()

    p = so.recover_public_key_from_msg_hash(z)
    a = p.to_checksum_address()

    return {
        'from': a,
        'nonce': int.from_bytes([0], 'big'),
        'gasPrice': int.from_bytes([1], 'big'),
        'gas': int.from_bytes([2], 'big'),
        'to':  web3.Web3.toChecksumAddress('0x' + d[3].hex()),
        'value': int.from_bytes(d[4], 'big'),
        'data': '0x' + d[5].hex(),
        'v': chain_id,
        'r': '0x',
        's': '0x',
            }

