# local imports
from .mined import MinedSyncer
from .base import Syncer


class HeadSyncer(MinedSyncer):
    """Implements the get method in Syncer for retrieving every new mined block.

    :param bc_cache: Retrieves block cache cursors for chain head and latest processed block.
    :type bc_cache: object implementing methods head(height) and backlog(height)
    """
    def __init__(self, w3, bc_cache):
        super(HeadSyncer, self).__init__(bc_cache)
        self.w3_filter = w3.eth.filter('latest')
   

    """Implements Syncer.get
    """
    def get(self):
        return self.w3_filter.get_new_entries()
