import logging
import os

import pytest

from cic_eth.db.models.tx import Tx, TxCache

logg = logging.getLogger()


def tx_random(n):
    return '0x' + os.urandom(n).hex()


def test_block_track_store(
        init_database,
#        init_registry,
        ):
    return True


def test_block_track_latest(
        init_database,
        ):
   
    t = Tx(tx_random(32), True)
    init_database.add(t)
    init_database.commit()

    logg.debug('tx {}'.format(t.tx_hash))
    tc = TxCache(
            t.tx_hash,
            tx_random(20),
            tx_random(20),
            tx_random(20),
            tx_random(20),
            100,
            100,
            42,
            13,
            )
    init_database.add(tc)
    init_database.commit()

    tc = TxCache(
            t.tx_hash,
            tx_random(20),
            tx_random(20),
            tx_random(20),
            tx_random(20),
            200,
            200,
            42,
            12,
            )

    init_database.add(tc)
    init_database.commit()

    tc = TxCache(
            t.tx_hash,
            tx_random(20),
            tx_random(20),
            tx_random(20),
            tx_random(20),
            300,
            300,
            40,
            13,
            )

    init_database.add(tc)
    init_database.commit()

    tt = TxCache.load()
    print(tt)

    assert(tt.tx_index == 13)
    assert(tt.block_number == 42)

