# standard imports
import enum

class StatusEnum(enum.IntEnum):
    """

    - Inactive, not finalized. (<0)
        * PENDING: The initial state of a newly added transaction record. No action has been performed on this transaction yet.
        * SENDFAIL: The transaction was not received by the node.
    - Active state: (==0)
        * SENT: The transaction has been sent to the mempool.
    - Inactive, finalized. (>0)
        * FUBAR: Unknown error occurred and transaction is abandoned. Manual intervention needed.
        * CANCELLED: The transaction was sent, but was not mined and has disappered from the mempool.
        * REJECTED: The transaction was rejected by the node.
        * REVERTED: The transaction was mined, but exception occurred during EVM execution. (Block number will be set)
        * SUCCESS: THe transaction was successfully mined. (Block number will be set)

    """
    PENDING=-9
    SENDFAIL=-8
    OBSOLETED=-2
    WAITFORGAS=-1
    SENT=0
    CANCELLED=1
    REJECTED=2
    FUBAR=3
    REVERTED=8
    SUCCESS=9


class TxTypeEnum(enum.Enum):
    TOKEN = 'token'
    CONVERT = 'convert'
