"""
.. module:: wallet
   :synopsis: Wallet interaction functions

.. moduleauthor:: Louis Holbrook <dev@holbrook.no>

"""
# standard imports
import logging

# third-party imports
import celery

# local import
from cic_eth.eth import RpcClient

logg = logging.getLogger(__file__)
celery_app = celery.current_app 


@celery_app.task()
def create(password):
    """Creates and stores a new ethereum account in the keystore.

    The password is passed on to the wallet backend, no encryption is performed in the task worker.

    :param password: Password to encrypt private key with
    :param type: str
    :return: Ethereum address of newly created account
    :rtype: str, 0x-hex
    """
    c = RpcClient()
    a = c.w3.eth.personal.new_account(password)
    logg.debug('created account {}'.format(a))
    return a
