# standard imports
import logging

# third-party imports
import celery

# local impotes
from .base import Syncer
from cic_eth.queue.tx import set_final_status

app = celery.current_app
logg = logging.getLogger()


class MinedSyncer(Syncer):
    """Base implementation of block processor for mined blocks.

    Loops through all transactions, 

    :param block_hash_hex: Block hash
    :type block_hash_hex: str, 0x-hash
    """

    def __init__(self, rpc, bc_cache):
        super(MinedSyncer, self).__init__(bc_cache)
        self.rpc = rpc
        self.w3 = rpc.w3


    def process(self, w3, block_hash_hex):
        logg.debug('processing {}'.format(block_hash_hex))
        b = w3.eth.getBlock(block_hash_hex)
        c = w3.eth.getBlockTransactionCount(block_hash_hex)
        for i in range(c):
            tx = w3.eth.getTransactionByBlock(block_hash_hex, i)
            tx_hash_hex = tx['hash'].hex()
            rcpt = w3.eth.getTransactionReceipt(tx_hash_hex)
            logg.debug('{}/{} processing tx {} from block {}'.format(i+1, c, tx_hash_hex, block_hash_hex))
            ours = False
            for f in self.filter:
                try:
                    task_uuid = f(w3, tx, rcpt)
                except Exception as e:
                    logg.error('error in filter {} tx {}: {}'.format(f, tx_hash_hex, e))
                    continue
                if task_uuid != None:
                    logg.debug('tx {} passed to celery task {}'.format(tx_hash_hex, task_uuid))
                    s = celery.signature(
                            'set_final_status',
                            [tx_hash_hex, rcpt['blockNumber'], not rcpt['status']],
                            )
                    s.apply_async()
                    break

        return b['number']

