# standard imports
import logging

# local imports
from cic_eth.eth.gas import GasOracle
from cic_eth.eth.nonce import NonceOracle

logg = logging.getLogger()


class RpcClient(GasOracle):
    signer_ipc_path = None
    provider_url = None
    web3_constructor = None


    def __init__(self, holder_address=None): #, provider_url, signer_ipc_path='/run/crypto-dev-signer/jsonrpc.ipc'):
        (self.provider, w3) = RpcClient.web3_constructor() #provider_url, signer_ipc_path)
        super(RpcClient, self).__init__(w3)
        if holder_address != None:
            self.holder_address = holder_address
            #self.nonce = self.w3.eth.getTransactionCount(self.holder_address, 'pending')
            #logg.info('"pending" nonce {} for address {}'.format(self.nonce, self.holder_address))
            #self.gas_price = self.__gas_price(self.w3)
            logg.info('gasprice {}'.format(self.gas_price()))


    @staticmethod
    def set_constructor(web3_constructor):
        RpcClient.web3_constructor = web3_constructor
