# third-party imports
import web3


contract_function_signatures = {
        'giveto': '63e4bff4', # keccak256(giveTo(address))
    }

def unpack_giveto(data):
    f = data[2:10]
    if f != contract_function_signatures['giveto']:
        raise ValueError('Invalid transfer data ({})'.format(f))

    d = data[10:]
    return {
        'to': web3.Web3.toChecksumAddress('0x' + d[64-40:64]),
        }


