# standard imports
import json

# third party imports
import pytest
import celery

# local imports
from cic_notify.tasks.sms import db
from cic_notify.tasks.sms import log

def test_log_notification(
    celery_session_worker,
        ):

    recipient = '+25412121212'
    content = 'bar'
    s_log = celery.signature('notify.sms.log')
    t = s_log.apply_async(args=[recipient, content])

    r = t.get()


def test_db_notification(
    init_database,
    celery_session_worker,
        ):

    recipient = '+25412121213'
    content = 'foo'
    s_db = celery.signature('notify.sms.db')
    t = s_db.apply_async(args=[recipient, content])

    r = t.get()
