# standard imports
import os

# third-party imports
from web3 import Web3, HTTPProvider
import pytest
from cic_registry import bancor


@pytest.fixture(scope='session')
def init_w3_nokey(
        ):
    provider = HTTPProvider('http://localhost:8545')
    return Web3(provider)


@pytest.fixture(scope='session')
def init_registry(
        init_w3_nokey,
        ):
    contract_registry = os.environ['CIC_BANCOR_REGISTRY_ADDRESS']
    this_dir = os.path.dirname(__file__)
    bancor_dir_default = os.path.join(this_dir, '../../contrib/bancor_0.6')
    bancor_dir = os.environ.get('CIC_BANCOR_DIR', bancor_dir_default)
    bancor.load(init_w3_nokey, contract_registry, bancor_dir)


