class ChainSpec:

    def __init__(self, chain_config, block_offset=0):
        self.chain_config = chain_config
        self.block_offset = block_offset # earliest block to consider


    def chain_id(self):
        return self.chain_config['params']['networkID']


    def chain_name(self):
        return self.chain_config['name']


    def __str__(self):
        return '{}:{}'.format(self.chain_name(), self.chain_id())


    @staticmethod
    def from_chain_str(s):
        (chain_name, chain_id) = s.split(':')
        return ChainSpec({
            'params': {
                'networkID': int(chain_id),
                },
            'name': chain_name,
            }
            )
