# standard imports
import logging

# third-party imports
import pytest
from eth_accounts_index import AccountRegistry

logg = logging.getLogger(__file__)


# TODO: Add default chain registry and insert
@pytest.fixture(scope='session')
def accounts_registry(
        config,
        w3,
        ):
    constructor = w3.eth.contract(abi=AccountRegistry.abi(), bytecode=AccountRegistry.bytecode())
    tx_hash = constructor.constructor().transact()
    r = w3.eth.getTransactionReceipt(tx_hash) 
    logg.debug('accounts registry deployed {}'.format(r.contractAddress))
    return AccountRegistry(w3, r.contractAddress)
