# third-party imports
import pytest

# local imports
from cic_registry import CICRegistry
from cic_registry import Contract
from cic_registry import registry_identifiers


@pytest.fixture(scope='session')
def cic_registry(
        bloxberg_config,
        default_chain_registry,
        bancor_registry,
        accounts_registry,
        w3,
        ):
    constructor = w3.eth.contract(abi=CICRegistry.abi(), bytecode=CICRegistry.bytecode())
    ids = list(registry_identifiers.values())
    tx_hash = constructor.constructor(ids).transact()
    r = w3.eth.getTransactionReceipt(tx_hash)
    cic_registry_address = r.contractAddress

    accounts_registry_contract = Contract(accounts_registry.contract)

    chain_str_bytes = bytes(default_chain_registry.chain(), 'utf-8')
    chain_identifier = '0x{:0<64s}'.format(chain_str_bytes.hex())
    c = w3.eth.contract(abi=CICRegistry.abi(), address=cic_registry_address)
    c.functions.set(registry_identifiers['BancorRegistry'], bancor_registry.address, chain_identifier, bloxberg_config['digest']).transact()
    c.functions.set(registry_identifiers['AccountRegistry'], accounts_registry_contract.address(), chain_identifier, bloxberg_config['digest']).transact()
    c.functions.set(registry_identifiers['CICRegistry'], cic_registry_address, chain_identifier, bloxberg_config['digest']).transact()

    CICRegistry.add_chain_registry(default_chain_registry)

    CICRegistry.finalize(w3, cic_registry_address)

    return CICRegistry
