# standard imports
import os
import logging
import json

# third-party imports
import pytest
from cic_registry.bancor import BancorRegistry, BancorDeployer
from cic_registry import bancor

script_dir = os.path.dirname(os.path.realpath(__file__))
root_dir = os.path.dirname(script_dir)
#bancor_default_dir = os.path.join(root_dir, 'bancor')
bancor_default_dir = '/usr/local/share/cic/bancor'

logg = logging.getLogger(__name__)


@pytest.fixture(scope='session')
def bancor_reserve_token(
        bancor_deployer,
        config,
        w3,
        ):
    abi = bancor_deployer.abi('EtherToken')
    bytecode = bancor_deployer.bytecode('EtherToken')
    c = w3.eth.contract(abi=abi, bytecode=bytecode)
    tx_hash = c.constructor('Reserve Token', 'RZV').transact({
        'from': w3.eth.accounts[0],
        })
    rcpt = w3.eth.getTransactionReceipt(tx_hash)
    reserve_address = rcpt.contractAddress
    bancor_deployer.set_default_reserve(reserve_address)

    return rcpt.contractAddress


@pytest.fixture(scope='session')
def bancor_deployer(
        default_chain_registry,
        config,
        w3,
        ):
    bancor_dir = config.get('BANCOR_DIR', bancor_default_dir)
    deployer = BancorDeployer(w3, bancor_dir)
    deployer.deploy()
    return deployer


@pytest.fixture(scope='session')
def bancor_tokens(
    w3,
    bancor_deployer,
    bancor_reserve_token,
    tokens_to_deploy,
        ):

    reserve_address = bancor_deployer.contract('ERC20Token', 'BNTToken').address

    token_addresses = []
    for t in tokens_to_deploy:
        logg.debug('deploying token {} ({}) with reserve {} owner {}'.format(t[1], t[2], reserve_address, w3.eth.accounts[t[0]]))
        w3.eth.sendTransaction({
            'from': w3.eth.accounts[t[0]],
            'to': reserve_address,
            'value': t[4],
            })
        deployed_token = bancor_deployer.create_token(reserve_address, w3.eth.accounts[t[0]], t[1], t[2], t[3], t[4])
        token_addresses.append(deployed_token)

    return token_addresses


@pytest.fixture(scope='session')
def bancor_registry(
        config,
        w3,
        default_chain_registry,
        bancor_deployer,
        bancor_tokens,
        ):
    registry_address = bancor_deployer.registry_contract.address
    bancor_dir = config.get('BANCOR_DIR', bancor_default_dir)
    registry = BancorRegistry(w3, default_chain_registry, registry_address, bancor_dir)
    registry.load()
    return registry


@pytest.fixture(scope='session')
def tokens_to_deploy(
        ):
    return [
        (1, 'Bert Token', 'BRT', 18, 100000), # account_index, token name, token symbol
        (2, 'Ernie Token', 'RNI', 18, 100000),
            ]

