"""Deploys CIC-Registry

.. moduleauthor:: Louis Holbrook <dev@holbrook.no>
.. pgp:: 0826EDA1702D1E87C6E2875121D2E7BB88C2A746 

"""

# SPDX-License-Identifier: GPL-3.0-or-later

# standard imports
import os
import json
import argparse
import logging

# third-party imports
import web3

# local imports
from cic_registry import registry_identifiers

logging.basicConfig(level=logging.WARNING)
logg = logging.getLogger()

logging.getLogger('web3').setLevel(logging.WARNING)
logging.getLogger('urllib3').setLevel(logging.WARNING)

script_dir = os.path.dirname(__file__)
data_dir = os.path.join(script_dir, '..', 'data')

argparser = argparse.ArgumentParser()
argparser.add_argument('-p', '--provider', dest='p', default='http://localhost:8545', type=str, help='Web3 provider url (http only)')
argparser.add_argument('-i', required=True, type=str, action='append', help='contract identifier')
argparser.add_argument('--abi-dir', dest='abi_dir', type=str, default=data_dir, help='Directory containing cic contract bytecode and abi (Default {})'.format(data_dir))
argparser.add_argument('-v', action='store_true', help='Be verbose')
args = argparser.parse_args()

if args.v:
    logg.setLevel(logging.DEBUG)

def main():
    w3 = web3.Web3(web3.Web3.HTTPProvider(args.p))

    f = open(os.path.join(args.abi_dir, 'Registry.json'), 'r')
    abi = json.load(f)
    f.close()

    f = open(os.path.join(args.abi_dir, 'Registry.bin'), 'r')
    bytecode = f.read()
    f.close()

    chain_specs = []
    for ci in args.i:
        ci_hex = ci.encode('utf-8').hex()
        chain_spec_hex = '0x{:0<64s}'.format(ci_hex)
        chain_specs.append(chain_spec_hex)

    logg.debug('chain specs {}'.format(chain_specs))
    w3.eth.defaultAccount = w3.eth.accounts[0]

    c = w3.eth.contract(abi=abi, bytecode=bytecode)
    tx_hash = c.constructor(chain_specs).transact()
    rcpt = w3.eth.getTransactionReceipt(tx_hash)
    address = rcpt.contractAddress
    c = w3.eth.contract(abi=abi, address=address)

    print(address)

if __name__ == '__main__':
    main()
