"""Seal the CIC-Registry contract, preventing further modifications

.. moduleauthor:: Louis Holbrook <dev@holbrook.no>
.. pgp:: 0826EDA1702D1E87C6E2875121D2E7BB88C2A746 

"""

# SPDX-License-Identifier: GPL-3.0-or-later

# standard imports
import os
import json
import argparse
import logging

# third-party imports
import web3

# local imports
from cic_registry import registry_identifiers

logging.basicConfig(level=logging.WARNING)
logg = logging.getLogger()

logging.getLogger('web3').setLevel(logging.WARNING)
logging.getLogger('urllib3').setLevel(logging.WARNING)

script_dir = os.path.dirname(__file__)
data_dir = os.path.join(script_dir, '..', 'data')

argparser = argparse.ArgumentParser()
argparser.add_argument('-p', '--provider', dest='p', default='http://localhost:8545', type=str, help='Web3 provider url (http only)')
argparser.add_argument('-r', required=True, type=str, help='cic registry address')
argparser.add_argument('--abi-dir', dest='abi_dir', type=str, default=data_dir, help='Directory containing cic contract bytecode and abi (Default {})'.format(data_dir))
argparser.add_argument('-v', action='store_true', help='Be verbose')
args = argparser.parse_args()


if args.v:
    logg.setLevel(logging.DEBUG)


def main():
    w3 = web3.Web3(web3.Web3.HTTPProvider(args.p))

    f = open(os.path.join(args.abi_dir, 'Registry.json'), 'r')
    abi = json.load(f)
    f.close()

    w3.eth.defaultAccount = w3.eth.accounts[0]
    c = w3.eth.contract(abi=abi, address=args.r)

    tx = c.functions.seal().transact()

    print(tx.hex())


if __name__ == '__main__':
    main()
