# third-party imports
import pytest
import os
import json

# local imports
from cic_registry import CICRegistry
from cic_registry.contract import Contract
from cic_registry import registry_identifiers

__script_dir = os.path.dirname(__file__)
__data_dir = os.path.join(__script_dir, '..', 'data')


@pytest.fixture(scope='session')
def init_cic_registry(
        bloxberg_config,
        default_chain_registry,
        bancor_registry,
        accounts_registry,
        w3,
        ):
    constructor = w3.eth.contract(abi=CICRegistry.abi(), bytecode=CICRegistry.bytecode())
    ids = list(registry_identifiers.values())
    tx_hash = constructor.constructor(ids).transact()
    r = w3.eth.getTransactionReceipt(tx_hash)
    cic_registry_address = r.contractAddress

    accounts_registry_contract = Contract(accounts_registry.contract, 'AccountRegistry')

    chain_str_bytes = bytes(default_chain_registry.chain(), 'utf-8')
    chain_identifier = '0x{:0<64s}'.format(chain_str_bytes.hex())
    c = w3.eth.contract(abi=CICRegistry.abi(), address=cic_registry_address)
    c.functions.set(registry_identifiers['BancorRegistry'], bancor_registry.address, chain_identifier, bloxberg_config['digest']).transact()
    c.functions.set(registry_identifiers['AccountRegistry'], accounts_registry_contract.address(), chain_identifier, bloxberg_config['digest']).transact()
    c.functions.set(registry_identifiers['CICRegistry'], cic_registry_address, chain_identifier, bloxberg_config['digest']).transact()

    return cic_registry_address


@pytest.fixture(scope='session')
def cic_registry(
        default_chain_registry,
        init_cic_registry,
        w3,
    ):

    CICRegistry.add_chain_registry(default_chain_registry)
    CICRegistry.finalize(w3, init_cic_registry)
    return CICRegistry


@pytest.fixture(scope='session')
def abis(
        config,
        ):

    abi_path = config.get('ETH_ABI_DIR', __data_dir)

    abi_names = [
        'ERC20',
            ]

    abis = {}

    i = 0
    for n in abi_names:
        filename = os.path.join(abi_path, '{}.json'.format(n))
        f = open(filename, 'r')
        a = json.load(f)
        f.close()
        abis[n] = a

    return abis
