# CIC token deployment tool

CIC-CLI provides tooling to generate and publish metadata in relation to
token deployments.

To install the project (replacing \<VERSION> with the current version:
0.0.1):

``` shell
python setup.py sdist
pip install --extra-index-url https://pip.grassrootseconomics.net:8433 dist/cic-<VERSION>.tar.gz
```

## Structure of the components

![image](data:image/svg+xml;base64,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)

CIC-CLI is designed to interface any network type backend. The current
state of the package contains interface to EVM only. Thus, the examples
below are limited to the context of the EVM.

## Preparing for EVM token deployment

Some of the concepts described below assume familiarity with base
concepts of the CIC architecture. Please refer to the appropriate
documentation for more information.

To initialize a new token deployment for the EVM:

``` shell
cic init --target eth --name <token_name> --symbol <token_symbol> --precision <token_value_precision> <settings_folder>
```

To automatically fill in settings detected in the network for the EVM:

``` shell
cic ext --registry <contract_registry_address> -d <settings_folder> -i <chain_spec> -p <rpc_endpoint> eth
```
