# standard imports
import json

# external imports
from clicada.user import FileUserStore


categories = [
    'phone',
    'address',
        ]


def process_args(argparser):
    argparser.add_argument('--category', required=True, type=str, help='Identifier category')
    argparser.add_argument('identifier', type=str, help='Identifier to store a display tag for')
    argparser.add_argument('tag', type=str, help='Display tag to store for the identifier')


def extra_args():
    return {
        'category': None,
        'identifier': None,
        'tag': None,
            }


def apply_args(config, args):
    pass


def validate(config, args):
    if category not in categories:
        raise ValueError('Invalid category. Valid categories are: {}'.format(','.join(categories)))


def execute(ctrl):
    store_path = '.clicada'
    user_store = FileUserStore(None, ctrl.chain(), ctrl.get('_CATEGORY'), store_path, int(ctrl.get('FILESTORE_TTL')))
    user_store.put(ctrl.get('_IDENTIFIER'), json.dumps(ctrl.get('_TAG')), force=True)
    user_store.stick(ctrl.get('_IDENTIFIER'))
