# standard imports
import os
import sys
import shutil


class NotifyWriter:

    def __init__(self, writer=sys.stdout):
        (c, r) = shutil.get_terminal_size()
        self.cols = c
        self.fmt = "\r{:" + "<{}".format(c) + "}"
        self.w = writer
        self.notify_max = self.cols - 4

    
    def notify(self, v):
        if len(v) > self.notify_max:
            v = v[:self.notify_max]
        self.write('\x1b[0;36m... ' + v + '\x1b[0;39m')


    def ouch(self, v):
        if len(v) > self.notify_max:
            v = v[:self.notify_max]
        self.write('\x1b[0;91m!!! ' + v + '\x1b[0;39m')


    def write(self, v):
        s = str(v)
        if len(s) > self.cols:
            s = s[:self.cols]
        self.w.write(self.fmt.format(s))
